import uuid

from config import project_id, base_url, callback_url, private_key_file_path

from helper import make_request

url = f"{base_url}/api/v1/payment/p2p/payin"

# Пример тела запроса (payload).

payload = {
    "general": {
        "project_id": project_id,
        "payment_id": f"Test-python-int-{uuid.uuid4()}",
        "merchant_callback_url": f"{callback_url}/callback/info",
        "merchant_success_callback_url": f"{callback_url}/callback/success",
        "merchant_decline_callback_url": f"{callback_url}/callback/decline"
    },
    "payment": {
        "method": "international-p2p",
        "amount": 532500,  # Сумма в минорных единицах валюты. Например, 111100 = 1111.00.
        "currency": "RUB",
    },
    "sender": [],
    "customer": {
        "id": "<CUSTOMER_ID>",
        "ip_address": "203.0.113.10",
        "country": "RU",
    }
}

make_request(
    sub_merchant_id=project_id,
    private_key_file_path=private_key_file_path,
    url=url,
    payload=payload,
)
