import base64
import json
import time
import requests

from Crypto.Hash import SHA256
from Crypto.PublicKey import RSA
from Crypto.Signature.pkcs1_15 import PKCS115_SigScheme



def parse_json(prefix, _obj, _result):
    if isinstance(_obj, dict):
        for key, value in _obj.items():
            new_prefix = f"{prefix}:{key}" if prefix else key
            parse_json(new_prefix, value, _result)
    elif isinstance(_obj, list):
        for index, item in enumerate(_obj):
            new_prefix = f"{prefix}:{index}"
            parse_json(new_prefix, item, _result)
    else:
        _result.append(f"{prefix}:{_obj or 'None'}")


def normalize_message(_payload):
    _result = []
    parse_json('', _payload, _result)
    _result.sort()
    _joined_result = ";".join(_result)
    return _joined_result


def make_request(
        sub_merchant_id,
        private_key_file_path,
        payload,
        url,
):
    with open(private_key_file_path, 'rb') as f:
        private_key = RSA.importKey(f.read())

    public_key = private_key.public_key().export_key()
    api_key = base64.urlsafe_b64encode(public_key).decode('utf-8')
    timestamp = int(time.time())

    if payload:
        dumped = json.dumps(payload, separators=(",", ":"))
    else:
        dumped = "{}"

    joined_result = normalize_message(payload)

    message = "{}{}".format(
        base64.urlsafe_b64encode(joined_result.encode()).decode("utf-8"),
        str(timestamp),
    ).encode('utf-8')

    signer = PKCS115_SigScheme(private_key)
    signature = signer.sign(SHA256.new(message))
    base64_sign = base64.urlsafe_b64encode(signature).decode('ascii')

    headers = {
        'content-type': 'application/json',
        'x-access-token': api_key,
        'x-access-signature': base64_sign,
        'x-access-merchant-id': sub_merchant_id,
        'x-access-timestamp': str(timestamp),
    }

    if payload:
        response = requests.post(
            url,
            headers=headers,
            data=dumped,
        )
    else:
        response = requests.get(
            url,
            headers=headers,
        )

    print(response.status_code)
    print(response.text)
