from config import project_id, base_url, callback_url, private_key_file_path

from helper import make_request

url = f"{base_url}/api/v1/payment/ecom/payin"

# Пример тела запроса (payload).

payload = {
    "general": {
        "project_id": project_id,
        "payment_id": "<PAYMENT_ID>",
        "merchant_callback_url": f"{callback_url}/callback/info",
        "merchant_success_callback_url": f"{callback_url}/callback/success",
        "merchant_decline_callback_url": f"{callback_url}/callback/decline",
        "redirect_url": "https://example.com/redirect"
    },
    "payment": {
        "method": "card-ecom",
        "amount": 111100,  # Сумма в минорных единицах валюты. Например, 111100 = 1111.00.
        "currency": "KZT",
        "lifetime": 900,
    },
    "card": {
        "pan": "<CARD_PAN>",
        "year": 2029,
        "month": 1,
        "card_holder": "<CARD_HOLDER>",
        "cvv": "<CARD_CVV>"
    },
    "customer": {
        "id": "<CUSTOMER_ID>",
        "ip_address": "203.0.113.10",
        "country": "KZ",
    }
}

make_request(
    sub_merchant_id=project_id,
    private_key_file_path=private_key_file_path,
    url=url,
    payload=payload,
)
