# Пример интеграции на Python

Пример H2H-интеграции с платежным шлюзом HighHelp на Python. Реализовано формирование подписи запросов, вызовы API для управления платежами и выплатами, обработка оповещений. В скриптах используется алгоритм RSA-SHA256 по умолчанию.

## Требования

* Python 3.10+
* pip

Пример проверен на указанных версиях. При использовании других версий корректность работы не гарантируется.

## Установка

### Установка зависимостей

Создайте виртуальное окружение и установите зависимости:

```bash
python -m venv .venv
```

Linux/macOS:

```bash
source .venv/bin/activate
pip install -r requirements.txt
```

Windows (PowerShell):

```powershell
.\.venv\Scripts\Activate.ps1
pip install -r requirements.txt
```

### Настройка параметров

Откройте `config.py` и укажите:

* `project_id` — ID кассы (в личном кабинете: **Кассы** -> **ID**);
* `callback_url` — URL для получения оповещений;
* `base_url` — URL API.

### Настройка ключей для подписи запросов

1. Сгенерируйте RSA-ключи в личном кабинете.
2. Сохраните приватный ключ в файл `private_key_for_api.pem` (в корне примера).

## Состав примера

* `config.py` — конфигурация (ID кассы, URL, пути к ключам);
* `helper.py` — формирование подписи и отправка запросов к API;
* `banks_get.py` — получение списка банков;
* `payment_create.py` — создание заявки на оплату;
* `payment_get_info.py` — получение статуса платежа;
* `payout_create.py` — создание заявки на выплату;
* `payout_get_info.py` — получение статуса выплаты;
* `p2p_*` и `ecom_*` — дополнительные примеры для отдельных методов/валют;
* `callback_processor.py` — обработчик оповещений с проверкой подписи.

## Выполнение операций API

Запустите необходимый скрипт. Примеры:

```bash
python banks_get.py
python payment_create.py
python ecom_kzt_create_payment_card.py
```

Скрипт выполняет запрос к API и выводит результат в терминал.

При успешном выполнении скрипт выводит:

* тело запроса;
* ответ сервера.

При ошибке выводится информация об ошибке, возвращенной API или логикой формирования подписи.

## Обработка оповещений

### Настройка ключей для проверки подписи оповещений

Для проверки подписи оповещений от платежного шлюза используются:

* публичный RSA-ключ -- при подписи оповещений по алгоритму RSA-SHA256;
* HMAC-ключ -- при подписи оповещений по алгоритму HMAC-SHA512.

Выполните шаги:

1. Откройте личный кабинет мерчанта.
2. Перейдите в раздел **API** -> **Настройки Callback**.
3. В открывшейся модальной форме внизу отображается настроенный для кассы алгоритм: **Алгоритм: RSA** или **Алгоритм: HMAC**.
4. В зависимости от настроенного алгоритма:
   * для RSA отображается блок **Public Key**;
   * для HMAC отображается блок **HMAC key**.
5. Для RSA нажмите на иконку скачивания и сохраните файл с ключом в директории примера.
6. Переименуйте файл в `public_key_for_callbacks.pem` (для RSA) или сохраните согласно настройкам в `callback_processor.py`.

Если требуется сменить алгоритм подписи, обратитесь к специалисту HighHelp.

**Important!**: Секретный HMAC-ключ доступен для скачивания только в момент генерации или обновления. После скачивания в разделе **API** → **Настройки Callback** отображается маскированное значение ключа; повторное скачивание недоступно, доступно только обновление ключа.

### Запуск обработчика оповещений

Запустите сервис обработки оповещений:

```bash
php -S localhost:8000 callback_processor.py
```

Параметры сервиса:

* порт: `8000`;
* endpoint: `/callback/{status}`.

Сервис проверяет подпись каждого входящего оповещения (RSA или HMAC в зависимости от конфигурации) и выводит результат проверки в терминал.

При корректной подписи выводится сообщение:

```text
Signature is valid (via OpenSSL)
```