<?php
require_once 'config.php';
require_once 'helper.php';

$url = "$base_url/api/v1/payment/p2p/payin";

# Тело запроса является примером, для более подробной информации обратитесь в документацию

$payload_spb = [
    "general" => [
        "project_id" => $project_id,
        "payment_id" => "Test-php-sbp",
        "merchant_callback_url" => "$callback_url/callback/info",
        "merchant_success_callback_url" => "$callback_url/callback/success",
        "merchant_decline_callback_url" => "$callback_url/callback/decline",
    ],
    "payment" => [
        "method" => "sbp-p2p",
        "amount" => 111100,     // Указывается в минорных единицах 111100 = 1111.00 рублей
        "currency" => "RUB",
    ],
    "sender" => [],
    "customer" => [
        "id" => "customer-id-1",
        "ip_address" => "192.168.0.1",
        "country" => "RU",
    ]
];

$payload_card = [
    "general" => [
        "project_id" => $project_id,
        "payment_id" => "Test-php-card",
        "merchant_callback_url" => "$callback_url/callback/info",
        "merchant_success_callback_url" => "$callback_url/callback/success",
        "merchant_decline_callback_url" => "$callback_url/callback/decline",
    ],
    "payment" => [
        "method" => "card-p2p",
        "amount" => 111100, # В минорных единицах 111100 = 1111.00 рублей
        "currency" => "RUB",
    ],
    "sender" => [],
    "customer" => [
        "id" => "customer-id-1",
        "ip_address" => "192.168.0.1",
        "country" => "RU",
    ]
];

echo makeRequest(
    $project_id,
    $private_key_file_path,
    $url,
    $payload_spb
);

?>
